---
name: kodi-fonts
description: Kompletní přehled všech fontů dostupných v Kodi skinu Estuary. Použij při práci s XML layouty, když potřebuješ vybrat správný font pro text.
trigger: xml_skinning, font_selection, ui_design
---

# Kodi Estuary Skin - Kompletní přehled fontů

**DŮLEŽITÉ:** Kodi addon dialogy NEMOHOU použít vlastní fonty. Fonty jsou vždy načítány z aktivního skinu (Estuary).

## Základní informace

- **Hlavní font:** `NotoSans-Regular.ttf`
- **Hodiny:** `Roboto-Thin.ttf`
- **Monospace:** `NotoMono-Regular.ttf`
- **Výchozí font:** `font13` (30px) - Kodi použije tento pokud zadaný font neexistuje

---

## KOMPLETNÍ SEZNAM FONTŮ

### Standardní fonty (NotoSans-Regular, styl: lighten)

| Font ID | Velikost (px) | Popis |
|---------|--------------|-------|
| `font10` | 23 | Nejmenší text, metadata |
| `font12` | 25 | Malý text, popisy |
| `font13` | 30 | **VÝCHOZÍ** - běžný text |
| `font14` | 33 | Mírně větší text |
| `font27` | 27 | Střední text |
| `font32` | 32 | Větší text |
| `font37` | 37 | Velké nadpisy |
| `font45` | 45 | Velmi velký text |
| `font60` | 60 | Extra velký text |

### Narrow fonty (užší řádkování, linespacing: 0.8)

| Font ID | Velikost (px) | Popis |
|---------|--------------|-------|
| `font23_narrow` | 23 | Úzké řádkování pro malé texty |
| `font25_narrow` | 25 | Úzké řádkování pro popisy |
| `font27_narrow` | 27 | Úzké řádkování střední |

### Title fonty (NotoSans-Regular, styl: **bold**)

| Font ID | Velikost (px) | Popis |
|---------|--------------|-------|
| `font_flag` | 18 | Nejmenší tučný (pro vlaječky) |
| `font20_title` | 20 | Malý tučný titulek |
| `font25_title` | 25 | Střední tučný titulek |
| `font30_title` | 30 | Tučný jako font13 |
| `font32_title` | 32 | Větší tučný titulek |
| `font36_title` | 36 | Velký tučný titulek |
| `font40_title` | 40 | Velmi velký tučný |
| `font45_title` | 45 | Extra velký tučný |
| `font52_title` | 52 | Obrovský tučný |
| `font_MainMenu` | 60 | Hlavní menu, tučný |

### Speciální fonty

| Font ID | Soubor | Velikost | Popis |
|---------|--------|----------|-------|
| `font_clock` | Roboto-Thin.ttf | 70 | Hodiny |
| `WeatherTemp` | NotoSans-Regular | 120 | Teplota (aspect 0.85) |
| `Mono26` | NotoMono-Regular.ttf | 26 | Monospace font |

---

## Velikostní přehled (od nejmenšího)

```
font_flag         (18px bold)    - nejmenší tučný
font20_title      (20px bold)    - malý tučný
font10            (23px)         - nejmenší běžný
font23_narrow     (23px narrow)  - úzké řádkování
font12            (25px)         - malý text
font25_narrow     (25px narrow)  - úzké řádkování
font25_title      (25px bold)    - střední tučný
font27            (27px)         - střední text
font27_narrow     (27px narrow)  - úzké řádkování
font13            (30px)         - VÝCHOZÍ
font30_title      (30px bold)    - tučný jako výchozí
font32            (32px)         - větší text
font32_title      (32px bold)    - větší tučný
font14            (33px)         - mírně větší
font36_title      (36px bold)    - velký tučný
font37            (37px)         - velké nadpisy
font40_title      (40px bold)    - velmi velký tučný
font45            (45px)         - velmi velký text
font45_title      (45px bold)    - extra velký tučný
font52_title      (52px bold)    - obrovský tučný
font60            (60px)         - extra velký
font_MainMenu     (60px bold)    - hlavní menu
font_clock        (70px thin)    - hodiny
WeatherTemp       (120px bold)   - teplota
```

---

## Doporučení pro addon dialogy

### Titulky seriálů/filmů
```xml
<font>font37</font>       <!-- 37px běžný -->
<font>font30_title</font> <!-- 30px tučný -->
```

### Běžný text
```xml
<font>font13</font>       <!-- 30px výchozí -->
<font>font14</font>       <!-- 33px o něco větší -->
```

### Metadata, SxxExx, malé texty
```xml
<font>font10</font>       <!-- 23px nejmenší -->
<font>font12</font>       <!-- 25px malý -->
```

### Tučné nadpisy
```xml
<font>font25_title</font> <!-- 25px bold -->
<font>font32_title</font> <!-- 32px bold -->
<font>font36_title</font> <!-- 36px bold -->
```

---

*Zdroj: github.com/xbmc/xbmc/blob/master/addons/skin.estuary/xml/Font.xml*
