# Kodi Estuary Skin - Kompletni prehled fontu

Tato dokumentace obsahuje **kompletni prehled VSECH fontu** dostupnych v Kodi skinu Estuary.

> **DULEZITE:** Kodi addon dialogy NEMOHOU pouzit vlastni fonty. Fonty jsou vzdy nacitany z aktivniho skinu (Estuary).

---

## Zakladni informace

- **Hlavni font:** `NotoSans-Regular.ttf`
- **Hodiny:** `Roboto-Thin.ttf`
- **Monospace:** `NotoMono-Regular.ttf`
- **Vychozi font:** `font13` (30px) - Kodi pouzije tento pokud zadany font neexistuje

---

## KOMPLETNI SEZNAM FONTU

### Standardni fonty (NotoSans-Regular, styl: lighten)

| Font ID | Velikost (px) | Popis |
|---------|--------------|-------|
| `font10` | 23 | Nejmensi text, metadata |
| `font12` | 25 | Maly text, popisy |
| `font13` | 30 | **VYCHOZI** - bezny text |
| `font14` | 33 | Mirne vetsi text |
| `font27` | 27 | Stredni text |
| `font32` | 32 | Vetsi text |
| `font37` | 37 | Velke nadpisy |
| `font45` | 45 | Velmi velky text |
| `font60` | 60 | Extra velky text |

### Narrow fonty (uzsi radkovani, linespacing: 0.8)

| Font ID | Velikost (px) | Popis |
|---------|--------------|-------|
| `font23_narrow` | 23 | Uzke radkovani pro male texty |
| `font25_narrow` | 25 | Uzke radkovani pro popisy |
| `font27_narrow` | 27 | Uzke radkovani stredni |

### Title fonty (NotoSans-Regular, styl: **bold**)

| Font ID | Velikost (px) | Popis |
|---------|--------------|-------|
| `font_flag` | 18 | Nejmensi tucny (pro vlajecky) |
| `font20_title` | 20 | Maly tucny titulek |
| `font25_title` | 25 | Stredni tucny titulek |
| `font30_title` | 30 | Tucny jako font13 |
| `font32_title` | 32 | Vetsi tucny titulek |
| `font36_title` | 36 | Velky tucny titulek |
| `font40_title` | 40 | Velmi velky tucny |
| `font45_title` | 45 | Extra velky tucny |
| `font52_title` | 52 | Obrovsky tucny |
| `font_MainMenu` | 60 | Hlavni menu, tucny |

### Specialni fonty

| Font ID | Soubor | Velikost | Popis |
|---------|--------|----------|-------|
| `font_clock` | Roboto-Thin.ttf | 70 | Hodiny |
| `WeatherTemp` | NotoSans-Regular | 120 | Teplota (aspect 0.85) |
| `Mono26` | NotoMono-Regular.ttf | 26 | Monospace font |

---

## Velikostni prehled (od nejmensiho)

```
font_flag         (18px bold)    - nejmensi tucny
font20_title      (20px bold)    - maly tucny
font10            (23px)         - nejmensi bezny
font23_narrow     (23px narrow)  - uzke radkovani
font12            (25px)         - maly text
font25_narrow     (25px narrow)  - uzke radkovani
font25_title      (25px bold)    - stredni tucny
font27            (27px)         - stredni text
font27_narrow     (27px narrow)  - uzke radkovani
font13            (30px)         - VYCHOZI
font30_title      (30px bold)    - tucny jako vychozi
font32            (32px)         - vetsi text
font32_title      (32px bold)    - vetsi tucny
font14            (33px)         - mirne vetsi
font36_title      (36px bold)    - velky tucny
font37            (37px)         - velke nadpisy
font40_title      (40px bold)    - velmi velky tucny
font45            (45px)         - velmi velky text
font45_title      (45px bold)    - extra velky tucny
font52_title      (52px bold)    - obrovsky tucny
font60            (60px)         - extra velky
font_MainMenu     (60px bold)    - hlavni menu
font_clock        (70px thin)    - hodiny
WeatherTemp       (120px bold)   - teplota
```

---

## Doporuceni pro addon dialogy

### Titulky serialu/filmu
```xml
<font>font37</font>       <!-- 37px bezny -->
<font>font30_title</font> <!-- 30px tucny -->
```

### Bezny text
```xml
<font>font13</font>       <!-- 30px vychozi -->
<font>font14</font>       <!-- 33px o neco vetsi -->
```

### Metadata, SxxExx, male texty
```xml
<font>font10</font>       <!-- 23px nejmensi -->
<font>font12</font>       <!-- 25px maly -->
```

### Tucne nadpisy
```xml
<font>font25_title</font> <!-- 25px bold -->
<font>font32_title</font> <!-- 32px bold -->
<font>font36_title</font> <!-- 36px bold -->
```

---

*Zdroj: github.com/xbmc/xbmc/blob/master/addons/skin.estuary/xml/Font.xml*
*Posledni aktualizace: 2026-01-13*
