from PIL import Image
import os

BASE_PATH = "/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media"
IMG_NAME = "milionar_sidebar_header.png"
IMG_PATH = os.path.join(BASE_PATH, IMG_NAME)

def crop_center(image_path, output_path):
    img = Image.open(image_path)
    width, height = img.size
    
    # Target aspect ratio is approx 390:120 = 3.25
    # If we keep width 1024, target height should be around 315.
    # Let's crop slightly looser to be safe: 1024x340.
    
    target_height = 340
    
    top = (height - target_height) // 2
    bottom = top + target_height
    
    cropped_img = img.crop((0, top, width, bottom))
    cropped_img.save(output_path)
    print(f"Cropped image to {width}x{target_height} and saved to {output_path}")

if __name__ == "__main__":
    crop_center(IMG_PATH, IMG_PATH)
