# Autostart funkcionalita - doplněk Milionář

## Co to dělá
Při startu Kodi se automaticky otevře dialog "Můj seznam" (pokud je zapnuto).

## Implementované soubory

### 1. addon.xml
```xml
<extension point="xbmc.service" library="service.py" start="startup" />
```

### 2. service.py
- Spustí se při startu Kodi
- Zkontroluje nastavení `auto_start_my_list`
- Počká podle `auto_start_delay_seconds`
- Spustí dialog "Můj seznam"

### 3. settings.xml
```xml
<setting label="32191" id="auto_start_enabled" type="bool" default="false" />
<setting label="32193" id="auto_start_action" type="select" lvalues="32194|32195" default="0" subsetting="true" visible="eq(-1,true)" />
<setting label="32192" id="auto_start_delay_seconds" type="number" default="1" subsetting="true" visible="eq(-2,true)" />
```

### 4. Lokalizace
- **32190**: "Autostart"
- **32191**: "Zapnout automatické spuštění při startu Kodi"
- **32192**: "Zpoždění před autostart (sekundy)"
- **32193**: "Akce při autostartu"
- **32194**: "Spustit doplněk"
- **32195**: "Otevřít Můj seznam"

## Jak to funguje
1. Service se spustí při startu Kodi
2. Zkontroluje nastavení autostart
3. Počká nastavený počet sekund
4. Spustí vybranou akci podle nastavení

## Nastavení
- **Zapnout/vypnout**: `auto_start_enabled`
- **Akce**: `auto_start_action` (0 = spustit doplněk, 1 = otevřít Můj seznam)
- **Čas čekání**: `auto_start_delay_seconds` (default: 1 sekunda)

## Testování
1. Restart Kodi
2. Zapnout nastavení v doplňku
3. Nastavit čas čekání
4. Restart Kodi - dialog se otevře automaticky
