---
trigger: always_on
---

# **Kodi video addon** pro procházení filmů/seriálů a hraní her s AI

**Hlavní funkce:**
- 🎬 **TMDb procházení** - filmy, seriály, herci, režiséři podle žánrů/let/zemí
- 📺 **Webshare streamování** - přehrávání obsahu přes Webshare API
- 🤖 **AI Chat** - interaktivní doporučování filmů/seriálů s konverzačním rozhraním
- 🎯 **Hra Milionář** - kvíz ve stylu "Chcete být milionářem" s AI generovanými otázkami
- 🎙️ **AI TTS** - hlasové čtení otázek moderátorským stylem
- 💰 **Usage tracking** - sledování nákladů a tokenů pro všechny AI providery

**AI Providers:** OpenAI | Anthropic | Google | Mistral | Groq

# Pravidla vývoje

## 🇨🇿 Jazyk komunikace
- **Veškeré plány a dokumentace VŽDY v českém jazyce** - uživatel je Čech pan Mudrc
- Komentáře v kódu mohou být anglicky (pro kompatibilitu)

## 📚 Kodi dokumentace
- [Kodi Wiki](https://kodi.wiki/view/Main_Page)
- [Kodi Python API](https://codedocs.xyz/xbmc/xbmc/)
- Moduly: `xbmcgui`, `xbmcaddon`, `xbmcplugin`, `xbmcvfs`

## 🐍 Kódovací standardy
- **Konzistence** - dodržovat styl existujícího kódu v projektu
- **Znovupoužitelnost** - využívat existující helper funkce a moduly, nevytvářet duplicitní kód
- **Struktura projektu** - respektovat danou architekturu

## 🔒 Integrita a stabilita addonu
> ⚠️ **KRITICKÉ** - Toto je komplexní addon, vždy dbát na tyto principy:

- **Nikdy nerozbít existující funkcionalitu** - před změnami ověřit dopady na zbytek kódu
- **Nové funkce integrovat kompletně** - promítnout do všech relevantních částí (menu, settings, lokalizace, atd.)
- **Nemazat funkční kód** - pokud není explicitně požadováno, neodstraňovat existující funkcionalitu

## 🌍 Lokalizace
```python
addon = xbmcaddon.Addon()
text = addon.getLocalizedString(XXXXX)  # ID z strings.po
```

**Jazyky:** `cs_cz` (Čeština) | `en_gb` (Angličtina) | `sk_sk` (Slovenština)

**Nový string:** Použít správné ID range (kontrolovat existující)

## ⚙️ Settings
1. Přidat do `settings.xml` s odpovídajícím `label` ID
2. Přidat label string do `strings.po` všech jazyků

## 🛡️ Logování
```python
xbmc.log(f"[plugin.video.milionar] Info: {msg}", xbmc.LOGINFO)
xbmc.log(f"[plugin.video.milionar] Error: {msg}", xbmc.LOGERROR)
```

## 🚫 Zakázané praktiky
- `os.path` → použít `xbmcvfs`
- `print()` → použít `xbmc.log()`
- Hardcoded stringy → použít lokalizaci
