### Refaktor: MediaInfo dialog, GamePanel a Autoplay řízení

### Záměr
- **sjednocený dialog** pro film, seriál i konec epizody (autoplay)
- **oddělená herní vrstva** pro všechny režimy
- **centralizované metadata** z Kodi knihovny i z menu doplňku
- **autoplay řízení** přes jeden monitor

### Modulová struktura
- **Dialog**: `wcs/playback/dialogs/MediaInfoDialog.py`
  - Jeden dialog s parametrem `mode` (`media` | `autoplay`) a `media_type` (`movie` | `series`).
  - Volí správné XML, načte metadata, spravuje bindy (`WCS.Movie.*`, `WCS.Episode.*`, `WCS.Autoplay.*`).
  - Herní část deleguje do `GamePanel`.

- **Herní panel**: `wcs/playback/ui/GamePanel.py`
  - Sdílený panel pro hru v dialogu (film/seriál/autoplay).
  - Parametry: `property_prefix` (např. `WCS.Game` / `WCS.Autoplay.Game`), `show_flag_property` (např. `WCS.Movie.ShowGame`).
  - Řeší tlačítka 301–304, focus, countdown, viditelnost a stavy pro zavření.

- **Metadata**: `wcs/playback/metadata/MediaMetadata.py`
  - Získává a formátuje metadata pro film/epizodu.
  - Zdroje: Kodi JSON‑RPC (knihovna) a parametry z menu doplňku (cache).
  - Vrací rating texty a progress, sestavený „FullInfo“ text.

- **Autoplay monitor**: `wcs/playback/PlayerMonitorAutoplay.py`
  - Načítá časování z nastavení, počítá reálný countdown, otevírá dialog v režimu `autoplay`.
  - Vyhodnocuje akci uživatele a spouští další epizodu.

### Klíčové soubory a funkce
- `wcs/playback/dialogs/MediaInfoDialog.py`
  - `MediaInfoDialog(mode, media_type, ...)`
  - `MovieInfoManager.show_movie_info(...)`
  - `EpisodeInfoManager.show_episode_info(...)`

- `wcs/playback/ui/GamePanel.py`
  - `GamePanel(window, property_prefix, show_flag_property)`
  - `start_game(game_args)`, `toggle_visible()`, `handle_choice(index)`, `start_countdown(...)`

- `wcs/playback/metadata/MediaMetadata.py`
  - `get_movie_metadata(...)`, `get_episode_metadata(...)`
  - `format_rating(value, year)`

- `wcs/playback/PlayerMonitorAutoplay.py`
  - `AutoplayPlayerMonitor` (singleton)
  - `_show_countdown_dialog()`, `_handle_next_episode(...)`

### Volání v rámci doplňku
- Zobrazení dialogu (film/seriál): přes `MovieInfoManager` / `EpisodeInfoManager` z `wcs/playback/dialogs/MediaInfoDialog.py` (voláno z `wcs/utils.py`, `wcs/library/LibraryManager.py`).
- Autoplay: řízeno z `wcs/playback/PlayerMonitorAutoplay.py` (aktivace z knihovny a během přehrávání, vyvolání `MediaInfoDialog` s `mode='autoplay'`).

### Nezměněné části
- Existující XML dialogy zůstávají beze změny; bindy používají původní prefixy.
- Herní logika (`GameController`) se nemění, pouze je adaptovaná přes `GamePanel`.

### Implementační poznámky
- Důsledně používat `property_prefix` a `show_flag_property` v `GamePanel` (filmy/seriály/autoplay).
- Metadata vždy formátovat přes `MediaMetadata` pro jednotnost výstupu.


