### Webshare VIP – aktuální stav

- **Účel**: Průběžně držet aktuální informaci o VIP expiraci z Webshare a zobrazovat ji v Nastavení; citlivě upozornit na blížící se expiraci při skutečném přehrávání.

### Kdy a jak se kontroluje
- Po přihlášení k Webshare: zobrazí se informační notifikace s „Přihlášen: {uživatel}“ a aktuálním VIP textem.
- Otevření Nastavení doplňku: VIP informace se tiše obnoví, ale bez jakýchkoli upozornění.
- Přehrávání z doplňku (vyhledávání/Webshare): před startem přehrávání proběhne kontrola expirace; pokud je do konce ≤ nastavenému prahu, ukáže se varování.
- Přehrávání z Kodi knihovny (.strm): stejné chování jako výše – před přehráním proběhne kontrola a případné varování.
- Běžná volání Webshare API: po každém volání se VIP informace tiše aktualizuje (kvůli textu v Nastavení), ale bez varovných hlášení.

### Kde v doplňku
- `wcs/webshare/WebshareClient.py`: centrální volání API, správa přihlášení, načtení VIP dat a jejich zpracování; při přehrávání spouští kontrolu expirace.
- `wcs/login/DialogWebshareLogin.py`: po úspěšném přihlášení zobrazí informační notifikaci s VIP textem.
- `wcs/router.py` (otevření Nastavení): tiše obnoví VIP text pro zobrazení v Nastavení.
- Přehrávání
  - z doplňku: `resolve_playable_item(...)` (Webshare)
  - z knihovny: `wcs/utils.py` (film) a `wcs/library/LibraryManager.py` (epizoda)

### Nastavení a texty
- Nastavení (sekce „Účet Webshare.cz“)
  - Stav účtu: `webshare_status`
  - VIP informace: `webshare_vip_info`
  - Upozornit před vypršením VIP (dní): `webshare_vip_warn_days` (výchozí 7)
- Texty (lokalizace)
  - VIP text: „Konec: {YYYY-MM-DD}, Zbývá: {N dní}“
  - Přihlášení: „Přihlášen: {jméno}“ (prefix informační notifikace)
  - Varování expirace: „VIP končí {date} (zbývá {remaining})“

### Shrnutí
- Informační notifikace pouze po přihlášení.
- Varování expirace jen při skutečném přehrávání (z doplňku i z knihovny) a jen pokud do konce zbývá ≤ nastavenému prahu.
- V Nastavení a při běžných API voláních se nic neupozorňuje, pouze se tiše aktualizuje text VIP informace.
